<?php 
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/SezioneSdoppiata.php";
    
    if(isset($_GET["id"])) {
        $sezioneSdoppiata = new SezioneSdoppiata($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $sezioneSdoppiata->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione sezione sdoppiata</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Sezione sdoppiata creata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Sezione sdoppiata modificata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="card mb-4 box-shadow-lite">

                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($sezioneSdoppiata) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($sezioneSdoppiata) ? $sezioneSdoppiata->getId() : "0")); ?>">
                                
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-lg-6 d-md-flex align-items-center">
                                            <h6 class="mb-md-0 mr-2 text-nowrap">Sezione:</h6>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo((isset($sezioneSdoppiata) ? $sezioneSdoppiata->getNome() : "")) ?>" placeholder="Nome occorrenza">
                                        </div>
                                        <div class="col text-right">
                                            <a class="btn btn-outline-primary mt-2 mt-md-0" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                            <button class="btn btn-primary mt-2 mt-md-0" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                            <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=<?php echo((isset($sezioneSdoppiata) ? $sezioneSdoppiata->getId() : "0")); ?>&amp;operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                                <div class="row">

                                                    <div class="col-md-4 form-group">
                                                        <label>Spazio occupato</label>
                                                        <select class="form-control" name="spazioOccupato">
                                                        <?php 
                                                            foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                                if(isset($sezioneSdoppiata) && $sezioneSdoppiata->getSpazioOccupato()==$classe) {
                                                                    echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                                }
                                                                else {
                                                                    echo"<option value=\"$classe\">$descrizione</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                        <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                                    </div>
                                                    
                                                    <div class="col-md-4 form-group">
                                                        <label>Proporzioni</label>
                                                        <select class="form-control mr-3" id="proporzioni" name="proporzioni" onChange="aggiornaDivSezioneSdoppiata()" >
                                                        <?php 
                                                            $arrayProporzioni = array("col-md-6, col-md-6"=>"1/2 - 1/2",
                                                                "col-md-4, col-md-8"=>"1/3 - 2/3",
                                                                "col-md-3, col-md-9"=>"1/4 - 3/4",
                                                                "col-md-2, col-md-10"=>"1/6 - 5/6",
                                                                "col-md-8, col-md-4"=>  "2/3 - 1/3",
                                                                "col-md-9, col-md-3"=>  "3/4 - 1/4",
                                                                "col-md-10, col-md-2"=>  "5/6 - 1/6"
                                                            );
                                                            foreach($arrayProporzioni as $classe=>$descrizione) {
                                                                if($sezioneSdoppiata->getProporzioni()==$classe) {
                                                                    echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                                }
                                                                else {
                                                                    echo"<option value=\"$classe\">$descrizione</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                    </div>
                                                    
                                                    <div class="col-md-4 form-group">
                                                        <label for="">Altezza proporzionale</label>
                                                        <select class="form-control" name="altezza">
                                                            <?php 
                                                                foreach($arrayAltezze as $classe=>$descrizione) {
                                                                    if(isset($sezioneSdoppiata) && $sezioneSdoppiata->getAltezza()==$classe) {
                                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                                    }
                                                                    else {
                                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                                    }
                                                                }
                                                            ?>
                                                        </select>
                                                        <small class="form-text text-muted">Stabilisce l'altezza proporzionale occupata dalla sezione rispetto alla viewport</small>
                                                    </div>

                                                    <div class="col-md-4 form-group">
                                                        <label for="inputPassword3">Dove si trova immagine su mobile:</label>
                                                        <select class="form-control" name="doveSiTrovaImmagineSuMobile">
                                                        <?php 
                                                            $arrayPosizioniImmagine = array("Sopra il testo","Sotto il testo");
                                                            foreach($arrayPosizioniImmagine as $posizione) {
                                                                if($sezioneSdoppiata->getDoveSiTrovaImmagineSuMobile()==$posizione) {
                                                                    echo"<option value=\"$posizione\" selected>".ucfirst($posizione)."</option>";
                                                                }
                                                                else {
                                                                    echo"<option value=\"$posizione\">".ucfirst($posizione)."</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                    </div>
                                                    
                                                    <div class="col-md-4 form-group">
                                                        <label for="inputPassword3">Dove si trova immagine su desktop:</label>
                                                        <select class="form-control" name="doveSiTrovaImmagine">
                                                        <?php 
                                                            $arrayPosizioniImmagine = array("sinistra","destra");
                                                            foreach($arrayPosizioniImmagine as $posizione) {
                                                                if($sezioneSdoppiata->getDoveSiTrovaImmagine()==$posizione) {
                                                                    echo"<option value=\"$posizione\" selected>".ucfirst($posizione)."</option>";
                                                                }
                                                                else {
                                                                    echo"<option value=\"$posizione\">".ucfirst($posizione)."</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                    </div>
                                                    
                                                    <div class="col-md-3 form-group">
                                                        <label class="d-block">Usa parallax</label>
                                                        <input type="checkbox" name=usaParallax class="js-switch" value="si" <?php
                                                              if(isset($sezioneSdoppiata) && $sezioneSdoppiata->getUsaParallax()=="si") { // se il valore = si aggiunge la parola checked
                                                                echo"CHECKED";
                                                             }
                                                          ?> />
                                                        <small class="text-muted d-block">Attiva l'effetto parallasse</small>
                                                    </div>
                                                </form>    
                                                    <div class="w-100"></div>
                                                    
                                                    <div class="col-lg-6">
                                                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                                            <div class="card-header collapsed" data-toggle="collapse" href="#sezioneTestuale">
                                                                <a class="card-title">
                                                                    Sezione testuale
                                                                </a>
                                                            </div>
                                                            <div id="sezioneTestuale" class="collapse show">
                                                                <div class="card-body">
                                                                    <div class="form-row">
                                                                        <div class="form-group col-md-6">
                                                                            <label for="inputPassword3">Animazione:</label>
                                                                            <select class="form-control" name="animazioneTesto">
                                                                            <?php 
                                                                                foreach($arrayAnimazioni as $classe=>$descrizione) {
                                                                                    if($sezioneSdoppiata->getAnimazioneTesto()==$classe) {
                                                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                                                    }
                                                                                    else {
                                                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                                                    }
                                                                                }
                                                                            ?>
                                                                            </select>
                                                                        </div>
                                                                        
                                                                        <div class="col-md-6">
                                                                            <label>Colore sfondo</label>
                                                                            <div class="input-group colorpicker-component selettore-colore mb-3">
                                                                                <input type="text" id="colorePrimario" name="coloreDivTesto" value="<?php echo(isset($sezioneSdoppiata) ? $sezioneSdoppiata->getColoreDivTesto() : "") ?>" class="form-control" />
                                                                                <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div class="form-group">
                                                                        <label for="titolo-articolo">Classi aggiuntive</label>
                                                                        <input type="text" class="form-control" name="classeDivTesto" value="<?php echo(isset($sezioneSdoppiata) ? $sezioneSdoppiata->getClasseDivTesto() : "") ?>">
                                                                    </div>
                                                                    
                                                                    <textarea class="tiny" name="testo"><?php echo(isset($sezioneSdoppiata) ? $sezioneSdoppiata->getTesto() : "") ?></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-lg-6">
                                                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                                            <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                                                <a class="card-title">
                                                                    Immagine
                                                                </a>
                                                            </div>
                                                            <div id="ImmagineInEvidenza" class="collapse show">
                                                                <div class="card-body">
                                                                    <div class="form-row">
                                                                        <div class="form-group col-md-6">
                                                                            <label for="inputPassword3">Animazione:</label>
                                                                            <select class="form-control" name="animazioneImmagine">
                                                                            <?php 
                                                                                foreach($arrayAnimazioni as $classe=>$descrizione) {
                                                                                    if($sezioneSdoppiata->getAnimazioneImmagine()==$classe) {
                                                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                                                    }
                                                                                    else {
                                                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                                                    }
                                                                                }
                                                                            ?>
                                                                            </select>
                                                                        </div>
                                                                        
                                                                        <div class="form-group col-md-6">
                                                                            <label for="inputPassword3">Stile immagine:</label>
                                                                            <select class="form-control" name="stileImmagine">
                                                                            <?php 
                                                                                $arrayStiliImmagini = array("Immagine di sfondo","Contenuta in un tag img");
                                                                                foreach($arrayStiliImmagini as $stile) {
                                                                                    if($sezioneSdoppiata->getStileImmagine()==$stile) {
                                                                                        echo"<option value=\"$stile\" selected>$stile</option>";
                                                                                    }
                                                                                    else {
                                                                                        echo"<option value=\"$stile\">$stile</option>";
                                                                                    }
                                                                                }
                                                                            ?>
                                                                            </select>
                                                                        </div>
                                                                    </div>

                                                                    <div class="form-group">
                                                                        <label for="titolo-articolo">Tag alt</label>
                                                                        <input type="text" class="form-control" name="tagAltImmagine" value="<?php echo(isset($sezioneSdoppiata) ? $sezioneSdoppiata->getTagAltImmagine() : "") ?>">
                                                                        <small>Il tag alt può essere usato solo se lo stile selezionato per l'immagine è: <b>Contenuta in un tag img</b></small>
                                                                    </div>
                                                                    
                                                                    <div class="form-group">
                                                                        <label for="titolo-articolo">Classi aggiuntive</label>
                                                                        <input type="text" class="form-control" name="classeDivImmagine" value="<?php echo(isset($sezioneSdoppiata) ? $sezioneSdoppiata->getClasseDivImmagine() : "") ?>">
                                                                    </div>
                                                                    
                                                                    <div class="img-container">
                                                                        <div class="azioni">
                                                                            <div class="btn-group" role="group" aria-label="">
                                                                                <button onclick="eliminaImmagineOccorrenza()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                                            </div>
                                                                        </div>
                                                                        <img id="immagineElemento" class="img-fluid w-100 mb-3" src="../../../<?php echo((isset($sezioneSdoppiata) && $sezioneSdoppiata->getImmagine()!="") ? $sezioneSdoppiata->getImmagine() : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                                                    </div>

                                                                    <button type="button" class="btn btn-outline-primary btn-block mb-3" onclick="apriPopupSelezioneImmagini()"><i class="far fa-image"></i> Scegli da immagini caricate</button>

                                                                    <form action="controller/controllerComponente.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                                                        <div class="dz-message">
                                                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                                            <h5>Trascina o carica qui l'immagine</h5>
                                                                        </div>
                                                                        <div class="fallback">
                                                                            <input name="file" type="file" />
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                </form>
                                            </div>
                                    </div>
                                </div>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../../include/modal/modalSelezionaFoto.php";
            
            include "../include/jsBaseComponenti.php";
        ?>

        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagine",
                    id:<?php echo $sezioneSdoppiata->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function eliminaImmagineOccorrenza() {
                $.ajax({
                    type:"GET",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaImmagine",
                        id:<?php echo $sezioneSdoppiata->getId() ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineElemento").src="../../../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function apriPopupSelezioneImmagini() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        immaginePartenza:0,
                        numeroImmagini:18
                    },
                    success:function(codice) {
                        document.getElementById("divSelezioneFoto").innerHTML = codice;
                        $('#modal-seleziona-foto').modal('show');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaImmagineInEvidenzaDaPopup(percorso) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"modificaImmagineOccorrenzaConPercorso",
                        id:<?php echo $sezioneSdoppiata->getId() ?>,
                        percorso:percorso
                    },
                    success:function(risposta) {
                        if(risposta=="ok") {
                            document.getElementById("immagineElemento").src = "../../../"+percorso;
                        }
                        else {
                            alert(risposta);
                        }
                    }
                });
                $('#modal-seleziona-foto').modal('hide');
            }
            
            function aggiungiImmaginiModalSelezioneImmagini(immaginePartenza,numeroImmagini) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        id:<?php echo $sezioneSdoppiata->getId() ?>,
                        immaginePartenza:immaginePartenza,
                        numeroImmagini:numeroImmagini
                    },
                    success:function(codice) {
                        var vecchioCodice = document.getElementById("divSelezioneFoto").innerHTML; 
                        document.getElementById("divSelezioneFoto").innerHTML = vecchioCodice+codice;
                        
                        // aggiorno i dati del pulsante
                        var nuovaImmagineDiPartenza = immaginePartenza+numeroImmagini;
                        document.getElementById("divBottoneModalSelezionaFoto").innerHTML = '<button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmagini('+nuovaImmagineDiPartenza+','+numeroImmagini+')">Mostra altre immagini</button>';
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
